/**
 * \file: grl_configuration.h
 *
 * Common configuration interface for the graphic. This I/F could be mapped on any configuration
 * mechanism depending on the product.
 *
 * \component: svg_common
 *
 * \author: CSpetzler
 *
 * \copyright: (c) 2003 - 2011 ADIT Corporation
 *
 * This Software is under a dual license (MIT/GPL).
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */
#ifndef GRL_CONFIGURATION_H
#define GRL_CONFIGURATION_H


#include "svg_error.h"
#include "grl_dlt_log.h"

/**
 * \func GRL_get_hex32_config
 *
 * Get an unsigned 32 bit configuration value. If the value is stored as string a hexadezimal notation is assumed.
 *
 * \param  p_name                    : key value which is a string of up to 16 characters
 * \param  p_value                   : integer value for the key
 *
 * \return error of process or if positiv number of elements in p_value (in this function always 1)
 *
 */
extern GRL_error GRL_get_hex32_config(SVGChar *p_name, SVGUint32 *p_value);

/**
 * \func GRL_get_int_config
 *
 * Get a integer configuration value.
 *
 * \param  p_name                    : key value which is a string of up to 16 characters
 * \param  p_value                   : integer value for the key
 * \param  size                      : number of the maximal elements to be stored in p_value
 *
 * \return error of process or if positiv number of elements in p_value
 *
 */
extern GRL_error GRL_get_int_config(SVGChar *p_name, SVGInt32 *p_value, SVGUint32 size);

/**
 * \func GRL_get_string_config
 *
 * Get a string configuration value with a specific length.
 *
 * \param  p_name                    : key value which is a string of up to 16 characters
 * \param  p_value                   : value as array storing the character string
 * \param  size                      : number of the maximal elements to be stored in p_value (in byte)
 *
 * \return error of process or if positiv numeric length of the returning value
 *
 */
extern GRL_error GRL_get_string_config(SVGChar *p_name, SVGUint8 *p_value, SVGUint32 size);


#endif /* GRL_CONFIGURATION_H */
